clearvars
close all

iseed = 0;
repeats = 10;
dt = 10;
impvalues = {'OMP'};
impmarkers = {'bo','kx'};
formatSpec = '%f';
csmethods = [1,2];

theory=0.5;

for m=1:size(csmethods,2)
for j=1:size(impvalues,2)
  imp=impvalues{j};
  FILENAME = sprintf('%sm%d.txt',imp,m);
  fileID = fopen(FILENAME,'r');

  A = fscanf(fileID,formatSpec);
  B=zeros(19,20);
  for i=1:19
      B(i,:)=A((i-1)*20+1:i*20);
  end
  
  C=zeros(19,10);
  for i=1:10
      C(:,i)=B(:,i*2);
  end
  
  dt=zeros(1,19);
  for i=1:10
      dt(i)=i;
  end
  for i=1:9
      dt(i+10)=(i+1)*10;
  end
  hold on, plot(dt,mean(C,2),impmarkers{(m-1)+j},'MarkerSize',14,'LineWidth',3.2);
end
end

set(gcf,'units','points','position',[10,10,400,300]);
set(gca, 'FontSize', 30);
set(gca, 'LineWidth', 4);

set(gca,'xscale','log')
set(gca,'YTick', [0,200,400,600]);
xlim([1,100]);
ylim([0,600]);

xlabel('$\Delta t$','interpreter','latex');
ylabel('Run Time (s)','interpreter','latex');

hold on, plot(2,210,'bo','MarkerSize',12,'LineWidth',4);
text(2.5,210,'$L=50$ [iid]','FontSize',24,'interpreter','latex');
hold on, plot(2,100,'kx','MarkerSize',12,'LineWidth',4);
text(2.5,100,'$L=50$ [eq]','FontSize',24,'interpreter','latex');

plotname = sprintf('TauTiming.png');
saveas(gcf,plotname);